-- File is ROM program for loop nesting test
-- Copyright (C) 2019  Dr. Uwe Meyer-Baese.
-- =======================================================
LIBRARY ieee;
USE ieee.STD_LOGIC_1164.ALL;
USE ieee.STD_LOGIC_arith.ALL;
USE ieee.STD_LOGIC_unsigned.ALL;
-- =======================================================
ENTITY rom4096x32 IS
PORT (clk   : IN STD_LOGIC;      -- System clock
      reset : IN STD_LOGIC;      -- Asynchronous reset
      pma   : IN STD_LOGIC_VECTOR(0 TO 11); -- Program memory address
      pmd   : OUT STD_LOGIC_VECTOR(0 TO 31)); -- Program memory data
END ENTITY rom4096x32;
-- =======================================================
ARCHITECTURE fpga OF rom4096x32 IS
-- Program ROM definition and values
TYPE MEMP IS ARRAY (0 TO 4095) OF STD_LOGIC_VECTOR(0 TO 31);
CONSTANT prom : MEMP := (
X"b0000000", --      000:	 	imm	0
X"30201db4", --      004:	 	addik	r1, r0, 7604
X"12610000", --      008:	 	addk	r19, r1, r0
--... ======================================
--	volatile int * LED_ptr = (int *) 0x40000000; // ZYBO green LED address
X"b0004000", --     00C:	 	imm	16384
X"30600000", --       010:	 	addik	r3, r0, 0
X"f8730020", --       014:	 	swi	r3, r19, 32
--	volatile int * SW_ptr = (int *) 0x40010000; // 4 SW slider switch address
X"b0004001", --       018:	 	imm	16385
X"30600000", --       01C:	 	addik	r3, r0, 0
X"f8730024", --       020:	 	swi	r3, r19, 36
--... =========================================
--	SW_value = *(SW_ptr); // get SW value
X"e8730024", --      024:	 	lwi	r3, r19, 36
X"e8630000", --      028:	 	lwi	r3, r3, 0
X"f873001c", --      02C:		swi	r3, r19, 28
--	while (1) {
--		*(LED_ptr) = SW_value; // Show SW on LEDs
X"e8730020", --      030:	 	lwi	r3, r19, 32
X"e893001c", --      034:	 	lwi	r4, r19, 28
X"f8830000", --      038:	 	swi	r4, r3, 0
--	    for(i = 0; i < LOOP_ITERATIONS; i+=1){}
X"f8130048", --      03C:	 	swi	r0, r19, 72
X"b8000010", --      040:	 	bri	16		// 050
X"e8730048", --      044:	 	lwi	r3, r19, 72
X"30630001", --      048:	 	addik	r3, r3, 1
X"f8730048", --      04C:	 	swi	r3, r19, 72
X"e8930048", --      050:	 	lwi	r4, r19, 72
-- ===================== Reduce value for simulation 
X"b0000000", --      054:	 	imm	0
X"30600001", --      058:	 	addik	r3, r0, 1
--X"b000001e", --      054:	 	imm	30
--X"3060847f", --      058:	 	addik	r3, r0, -31617
X"16441803", --      05C:	 	cmpu	r18, r4, r3
X"bcb2ffe4", --      060:	 	bgei	r18, -28		// 480
--	    SW_value = SW_value ^ 0xFF; // Toggle LED
X"e873001c", --      064:	 	lwi	r3, r19, 28
X"a86300ff", --      068:	 	xori	r3, r3, 255
X"f873001c", --      06C:	 	swi	r3, r19, 28
--	}
X"b800ffc0", --      070:	 	bri	-64		// 2c   
--OTHERS => X"80000000"); -- default NOP
OTHERS => "UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU"); -- Default unknown mem

BEGIN
-- The following process will be mapped to a BlockRAM for Zynq/Virtex/Spartan
-- devices (if addr > 4 bit!) and to Distributed RAM in all other cases

prog_rom: PROCESS (reset, clk)
BEGIN
  IF reset = '0' THEN               -- Asynchronous clear
    pmd <= (OTHERS => '0');     
  ELSIF rising_edge(clk) THEN
      pmd <= prom(CONV_INTEGER(pma)); -- Read from ROM
  END IF;
END PROCESS;

END ARCHITECTURE fpga;
